#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <pthread.h>

pthread_mutex_t mutex;
pthread_cond_t cond;

#define BROJ_AUTOMOBILA_A 10
#define BROJ_AUTOMOBILA_B 10
#define BROJ_KAMIONA_A 1
#define BROJ_KAMIONA_B 1
#define BROJ_AUTOBUSA_A 1
#define BROJ_AUTOBUSA_B 1

#define A 1
#define B 2
#define PRAZNO 0

#define AUTO 10000
#define AUTOBUS 20000
#define KAMION 30000


int smer = 0;
int brojVozilaNaMostu = 0;
int brojKamionaNaMostu = 0;
int brojAutobusaNaMostu = 0;

void* smerA(void *t)
{
    long id = (long) t;
    int staSi;

    if(id >= 0 && id < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B)
    {
        staSi = AUTO;
    }
    else if(id > BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B && id < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B)
    {
        staSi = AUTOBUS;
    }
    else
    {
        staSi = KAMION;
    }

    int vremeDolaska = rand() % 5;
    printf("Vozilo %ld dolazi pred most za %ds \n", id, vremeDolaska);
    sleep(vremeDolaska);
    printf("Vozilo %ld je doslo pred most za %ds \n", id, vremeDolaska);

    pthread_mutex_lock(&mutex); //zatvori dok proveravam
    while((smer == B && staSi == AUTO && brojKamionaNaMostu > 0) || (smer == B && staSi == AUTOBUS && brojAutobusaNaMostu > 0 && brojKamionaNaMostu > 0) || (smer == B && staSi == KAMION && brojVozilaNaMostu != 0))
    {
        pthread_cond_wait(&cond, &mutex);
    }

    if(smer != A)
    {
        smer = A;
        brojVozilaNaMostu = 0;
        brojKamionaNaMostu = 0;
        brojAutobusaNaMostu = 0;
    }

    if(staSi == AUTO)
    {
        brojVozilaNaMostu ++;
    }
    else if(staSi == AUTOBUS && brojAutobusaNaMostu > 0 )
    {
        brojVozilaNaMostu ++;
        brojAutobusaNaMostu ++;
    }
    else if(staSi = KAMION && brojVozilaNaMostu != 0)
    {
        brojVozilaNaMostu ++;
        brojKamionaNaMostu ++;
    }

    pthread_mutex_unlock(&mutex);

    if(staSi == AUTO)
    {
        int vremeProlaska = rand() % 5;
        printf("Auto %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Auto %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }
    else if(staSi == AUTOBUS)
    {
        int vremeProlaska = rand() % 5;
        printf("Autobus %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Autobus %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }
    else
    {
        int vremeProlaska = rand() % 5;
        printf("Kamion %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Kamion %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }

    pthread_mutex_lock(&mutex);

    brojVozilaNaMostu --;
    if(staSi == AUTOBUS)
    {
        brojAutobusaNaMostu --;
    }
    else if(staSi == KAMION)
    {
        brojKamionaNaMostu --;
    }


    if(brojVozilaNaMostu == 0)
    {
        smer = PRAZNO;
        pthread_cond_broadcast(&cond);
    }
    //pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);
    pthread_exit(NULL);

}

void* smerB(void *t)
{
    long id = (long) t;
    int staSi;

    if(id >= 0 && id < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B)
    {
        staSi = AUTO;
    }
    else if(id > BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B && id < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B)
    {
        staSi = AUTOBUS;
    }
    else
    {
        staSi = KAMION;
    }

    int vremeDolaska = rand() % 5;
    printf("Vozilo %ld dolazi pred most za %ds \n", id, vremeDolaska);
    sleep(vremeDolaska);
    printf("Vozilo %ld je doslo pred most za %ds \n", id, vremeDolaska);

    pthread_mutex_lock(&mutex); //zatvori dok proveravam
    while((smer == A && staSi == AUTO && brojKamionaNaMostu > 0) || (smer == A && staSi == AUTOBUS && brojAutobusaNaMostu > 0 && brojKamionaNaMostu > 0) || (smer == A && staSi == KAMION && brojVozilaNaMostu != 0))
    {
        pthread_cond_wait(&cond, &mutex);
    }

    if(smer != B)
    {
        smer = B;
        brojVozilaNaMostu = 0;
        brojKamionaNaMostu = 0;
        brojAutobusaNaMostu = 0;
    }

    if(staSi == AUTO)
    {
        brojVozilaNaMostu ++;
    }
    else if(staSi == AUTOBUS && brojAutobusaNaMostu > 0 )
    {
        brojVozilaNaMostu ++;
        brojAutobusaNaMostu ++;
    }
    else if(staSi = KAMION && brojVozilaNaMostu != 0)
    {
        brojVozilaNaMostu ++;
        brojKamionaNaMostu ++;
    }

    pthread_mutex_unlock(&mutex);

    if(staSi == AUTO)
    {
        int vremeProlaska = rand() % 5;
        printf("Auto %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Auto %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }
    else if(staSi == AUTOBUS)
    {
        int vremeProlaska = rand() % 5;
        printf("Autobus %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Autobus %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }
    else
    {
        int vremeProlaska = rand() % 5;
        printf("Kamion %ld krece da kroz most, traje %ds \n", id, vremeProlaska);
        sleep(vremeProlaska);
        printf("Kamion %ld je prosao kroz most za %ds \n", id, vremeProlaska);
    }

    pthread_mutex_lock(&mutex);

    brojVozilaNaMostu --;
    if(staSi == AUTOBUS)
    {
        brojAutobusaNaMostu --;
    }
    else if(staSi == KAMION)
    {
        brojKamionaNaMostu --;
    }


    if(brojVozilaNaMostu == 0)
    {
        smer = PRAZNO;
        pthread_cond_broadcast(&cond);
    }
    //pthread_cond_broadcast(&cond);
    pthread_mutex_unlock(&mutex);
    pthread_exit(NULL);

}


int main(){

    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cond, NULL);

    pthread_t niti[BROJ_AUTOMOBILA_A+BROJ_AUTOMOBILA_B+BROJ_AUTOBUSA_A+BROJ_AUTOBUSA_B+BROJ_KAMIONA_A+BROJ_KAMIONA_B];
    //AUTOMOBILA A
    for(long t = 0; t < BROJ_AUTOMOBILA_A; t++)
    {
        pthread_create(&niti[t], NULL, smerA, (void*)t);
    }
    //AUTOMOBILA B
    for(long t = BROJ_AUTOMOBILA_A; t < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B; t++)
    {
        pthread_create(&niti[t], NULL, smerB, (void*)t);
    }
    //Autobusi A
    for(long t = BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B; t < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A; t++)
    {
        pthread_create(&niti[t], NULL, smerA, (void*)t);
    }
    //Autobusi B
    for(long t = BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A; t < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B; t++)
    {
        pthread_create(&niti[t], NULL, smerB, (void*)t);
        printf("Napravio sam autobus %ld\n", t);
    }
    //kamioni A
    for(long t = BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B; t < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B + BROJ_KAMIONA_A; t++)
    {
        pthread_create(&niti[t], NULL, smerA, (void*)t);
    }
    //kamioni B
    for(long t = BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B + BROJ_KAMIONA_A; t < BROJ_AUTOMOBILA_A + BROJ_AUTOMOBILA_B + BROJ_AUTOBUSA_A + BROJ_AUTOBUSA_B + BROJ_KAMIONA_A + BROJ_KAMIONA_B; t++)
    {
        pthread_create(&niti[t], NULL, smerB, (void*)t);
    }

    pthread_exit(NULL);
    return 0;
}